/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

#ifdef GL_ES
precision mediump float;
#endif

// schizo flower murrr

// uniform float time;      // Replaced for VGHD by defines above. TheEmu.
// uniform vec2 resolution; // Replaced for VGHD by defines above. TheEmu.

void main( void ) {
    vec2 p=(2.*scaled_gl_FragCoord.xy-resolution.xy) / resolution.y;
	float l = length(p);
	vec2 rm = vec2( sin( cos(time) * l ), tan( sin(time) * .5 ) );
	p = vec2( p.x*rm.x - p.y*rm.y, p.x*rm.y - p.y*rm.x);
		
    float b=abs(l-1.0)+(cos(250.*(atan(p.x,p.y))))*.13;

    gl_FragColor = vec4(b,abs(.8-b),1.-b, 1.4 );
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15
}